dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")
dofile(LockOn_Options.script_path.."sounds.lua")

local gettext = require("i_18n")
_ = gettext.translate

cursor_mode = 
{ 
    CUMODE_CLICKABLE = 0,
    CUMODE_CLICKABLE_AND_CAMERA  = 1,
    CUMODE_CAMERA = 2,
};

clickable_mode_initial_status  = cursor_mode.CUMODE_CLICKABLE
use_pointer_name			   = true

-- default_button renvoie la valeur 1 une fois et reste en position 1 tant que le bouton gauche est appuy�
-- revient � la position 0 d�s que la souris est relach�e et renvoie la valeur 0
-- arg_val_ doit �tre �gal � 1
-- arg_lim_ doit �tre �gal � {0,1}
function default_button(hint_,device_,command_,arg_,arg_val_,arg_lim_)

	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}

	return  {	
				class 				= {class_type.BTN},
				hint  				= hint_,
				device 				= device_,
				action 				= {command_},
				stop_action 		= {command_},
				arg 				= {arg_},
				arg_value			= {arg_val_}, 
				arg_lim 			= {arg_lim_},
				use_release_message = {true},
				updatable 	= true, 
			}
end

-- default_1_position_tumb = bouton 2 positions 0 et 1 souris gauche, souris droite inop�rante
function default_1_position_tumb(hint_, device_, command_, arg_, arg_val_, arg_lim_, sound_)
	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}
	return  {	
				class 		= {class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {arg_val_}, 
				arg_lim   	= {arg_lim_},
				updatable 	= true, 
				use_OBB 	= true,
				sound = sound_ and {{sound_,sound_}} or nil
			}
end

-- default_2_position_tumb = bouton 2 positions 0 et 1 souris gauche ou souris droite indiff�remment
function default_2_position_tumb(hint_, device_, command_, arg_, sound_)
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-1,1}, 
				arg_lim   	= {{0,1},{0,1}},
				updatable 	= true, 
				use_OBB 	= true,
				sound = sound_ and {{sound_,sound_}} or nil
			}
end

-- default_3_position_tumb = bouton 3 positions -1,0,1 souris gauche ou souris droite indiff�remment
function default_3_position_tumb(hint_,device_,command_,arg_,cycled_,inversed_)
	local cycled = true
	local val =  1
	if inversed_ then
	      val = -1
	end
	if cycled_ ~= nil then
	   cycled = cycled_
	end
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {val,-val}, 
				arg_lim   	= {{-1,1},{-1,1}},
				updatable 	= true, 
				use_OBB 	= true,
				cycle       = cycled
			}
end

-- default_axis = bouton rotatif
-- relative_ important
-- de 0 � 1
function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)
	
	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	
	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {{0,1}},
				updatable 	= updatable, 
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative}, 				
			}
end

-- default_movable_axis se d�place avec la souris gauche et renvoie la valeur atteinte
-- default_ mieux si �gal � 0
-- de 0 � 1
function default_movable_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)
	
	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	
	return  {	
				class 		= {class_type.MOVABLE_LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {{0,1}},
				updatable 	= updatable, 
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative}, 				
			}
end

-- default_axis_limited = bouton rotatif
-- relative_ important
-- arg_lim definissable
--[[function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)
	
	local relative = false
	local default = default_ or 0
	local updatable = updatable_ or false
	if relative_ ~= nil then
		relative = relative_
	end

	local gain = gain_ or 0.1
	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {arg_lim_},
				updatable 	= updatable, 
				use_OBB 	= false,
				gain		= {gain},
				relative    = {relative},  
			}
end]]

function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)
	
	
	local default = default_ or 0
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false
	--[[
	local relative = false
	if relative_ ~= nil then
		relative = relative_
	end
	]]

	return  {	
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default}, 
				arg_lim   	= {arg_lim_},
				updatable 	= updatable, 
				use_OBB 	= true,--false,
				gain		= {gain},
				relative    = {relative},
				cycle     	= false,
			}
end

-- multiposition_switch = bouton multi-position
-- count_ = nb positions
-- delta_ = valeur entre deux positions
function multiposition_switch(hint_,device_,command_,arg_,count_,delta_,inversed_, min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5
	
	local inversed = 1
	if	inversed_ then
		inversed = -1
	end
	
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed}, 
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true, 
				use_OBB 	= true
			}
end

-- multiposition_switch_limited = bouton multi-position non cycled
function multiposition_switch_limited(hint_,device_,command_,arg_,count_,delta_,inversed_,min_,sound_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5
	
	local inversed = 1
	if	inversed_ then
		inversed = -1
	end
	
	return  {	
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed}, 
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true, 
				use_OBB 	= true,
				cycle     	= false, 
				sound = sound_ and {{sound_,sound_}} or nil
			}
end

-- default_button_axis = bouton rotatif � deux commandes ???
function default_button_axis(hint_, device_,command_1, command_2, arg_1, arg_2, limit_1, limit_2)
	local limit_1_   = limit_1 or 1.0
	local limit_2_   = limit_2 or 1.0
return {
			class		=	{class_type.BTN, class_type.LEV},
			hint		=	hint_,
			device		=	device_,
			action		=	{command_1, command_2},
			stop_action =   {command_1, 0},
			arg			=	{arg_1, arg_2},
			arg_value	= 	{1, 0.5},
			arg_lim		= 	{{0, limit_1_}, {0,limit_2_}},
			animated        = {false,true},
			animation_speed = {0, 0.4},
			gain = {0, 0.1},
			relative	= 	{false, true},
			updatable 	= 	true, 
			use_OBB 	= 	true,
			use_release_message = {true, false}
	}
end

-- default_animated_lever = levier anim�
-- animation_speed_ 0.5 plus lent que 0.8
-- la valeur n'est retourn�e qu'apr�s l'animation
function default_animated_lever(hint_, device_, command_, arg_, animation_speed_,arg_lim_)
local arg_lim__ = arg_lim_ or {0.0,1.0}
return  {	
	class  = {class_type.TUMB, class_type.TUMB},
	hint   	= hint_, 
	device 	= device_,
	action 	= {command_, command_},
	arg 		= {arg_, arg_},
	arg_value 	= {1, 0},
	arg_lim 	= {arg_lim__, arg_lim__},
	updatable  = true, 
	gain 		= {0.1, 0.1},
	animated 	= {true, true},
	animation_speed = {animation_speed_, 0},
	cycle = true
}
end

-- default_button_tumb = bouton � deux commandes
-- bouton gauche commande 1
-- bouton droit commande 2
-- stop_action = {command1_,0}, => le bouton gauche revient au 0, alors que le bouton droit non
-- stop_action = {command1_,command2_}, => le bouton gauche et le bouton droit reviennent au 0
function default_button_tumb(hint_, device_, command1_, command2_, arg_,style)
	if style == 1 or style == nil then
		stop_action_ = {command1_,0}
	elseif style == 2 then -- speedbrake
		stop_action_ = {command1_,command2_}
	end
	return  {	
				class 		= {class_type.BTN,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command2_},
				stop_action = stop_action_,
				arg 	  	= {arg_,arg_},
				arg_value 	= {-1,1},
				arg_lim   	= {{-1,0},{0,1}},
				updatable 	= true, 
				use_OBB 	= true,
				use_release_message = {true,false}
			}
end

elements = {}
-- --Default Axis
-- elements["ALT_SETTING_PNT"] 			= default_axis("Altimeter Setting", 					devices.AVIONICS, device_commands.Button_1, 6, 0, 0.05, false, true)
-- --function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)
-- --Default Axis Limited
-- elements["PROP_MIX_PNT"] 				= default_axis_limited(_("Mixture Lever"), 				devices.ENGINE, device_commands.Button_3, 17, 0.0, -0.1, true, false, {0,1})
-- --elements["PROP_RPM_PNT"] 				= default_axis(_("RPM Lever"), 							devices.ENGINE, device_commands.Button_35, 12, 0, 0.05, false, true)
-- --function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)

-- --Multi Position
-- elements["FUEL_SELECTOR_PNT"] 			= multiposition_switch_limited(_("Fuel Selector"), 		devices.ENGINE, Keys.FuelSelector, 21, 3, .5, true, 0, KNOBCLICK)
-- elements["KEY_PNT"] 					= multiposition_switch_limited(_("Magnetos"),			devices.ENGINE, Keys.MagSelect, 14, 5, .25, true, 0, KNOBCLICK)
-- elements["CUSTOM_4_PNT"] 				= multiposition_switch_limited(_("Select Pilot"), 		devices.CUSTOM, device_commands.Button_13, nil, 6, .1, true, 0, KNOBCLICK)
-- elements["COLOR_PNT"] 					= multiposition_switch_limited(_("Flood Light Color"),  devices.CUSTOM, device_commands.Button_23, nil, 5, .1, true, 0, KNOBCLICK)

-- --1 Position
-- elements["UAV_PNT"] 					= default_1_position_tumb(_("UAV Mode"),				devices.AVIONICS,device_commands.Button_7,nil,1,{0,1}, TOGGLECLICK)
-- elements["LED_PNT"] 					= default_1_position_tumb(_("Racing LED Indicator Speed/G Toggle"), devices.AVIONICS,device_commands.Button_8,nil,1,{0,1}, TOGGLECLICK)
-- elements["CUSTOM_5_PNT"] 				= default_1_position_tumb(_("Hide Aersti Chart"),		devices.AVIONICS,device_commands.Button_6,nil,1,{0,1}, TOGGLECLICK)
-- elements["STOPWATCH_STARTSTOP_PNT"] 	= default_1_position_tumb(_("Stopwatch Start/Stop/Reset"), devices.STOPWATCH,device_commands.Button_5,nil,1,{0,1}, TOGGLECLICK)

-- --2 Position
-- elements["MSTR_PNT"] 					= default_2_position_tumb(_("Master"), 					devices.ELECTRIC, Keys.Master, 18, TOGGLECLICK)
-- elements["FUEL_PMP_PNT"] 				= default_2_position_tumb(_("Electric Boost Pump"), 	devices.ELECTRIC, Keys.ElectricFuelPump, 19, TOGGLECLICK)
-- elements["CANOPY_PNT"]             		= default_2_position_tumb("Canopy", 					devices.CANOPY, Keys.Canopy, 0)
-- elements["CUSTOM_1_PNT"] 				= default_2_position_tumb(_("Attach/Remove Winglets"),  devices.CUSTOM, device_commands.Button_10, nil, 1, {0,1}, TOGGLECLICK)
-- elements["CUSTOM_2_PNT"] 				= default_2_position_tumb(_("Attach/Remove Spades"), 	devices.CUSTOM, device_commands.Button_11, nil, 1, {0,1}, TOGGLECLICK)
-- elements["CUSTOM_3_PNT"] 				= default_2_position_tumb(_("Attach/Remove Lights"),  	devices.CUSTOM, device_commands.Button_12, nil, 1, {0,1}, TOGGLECLICK)

-- --EFIS Page Buttons
-- elements["BUTTON_1_PNT"] 				= default_button(_("NAV Page"),      					devices.CUSTOM, device_commands.Button_15, 34, 1, {0,1},   TOGGLECLICK)
-- --Below on hold for better idea, maybe the Race Day program interface
-- --elements["BUTTON_2_PNT"] 				= default_button(_("Engine Page"),      				devices.CUSTOM, device_commands.Button_16, 33, 1, {0,1},   TOGGLECLICK)
-- elements["BUTTON_3_PNT"] 				= default_button(_("System Page"),      				devices.CUSTOM, device_commands.Button_17, 32, 1, {0,1},   TOGGLECLICK)
-- elements["BUTTON_4_PNT"] 				= default_button(_("Mp3 Page"),      					devices.CUSTOM, device_commands.Button_18, 31, 1, {0,1},   TOGGLECLICK)
-- elements["BUTTON_5_PNT"] 				= default_button(_("Configuration Menu"),   		    devices.CUSTOM, device_commands.Button_1,  30, 1, {0,1},   TOGGLECLICK)

-- --System Page Buttons
-- elements["NAV_PNT"] 					= default_2_position_tumb(_("Navigation Lights"),      	devices.ELECTRIC, device_commands.Button_1, nil, 1, {0,1},   TOGGLECLICK)
-- elements["FLOOD_PNT"] 					= default_2_position_tumb(_("Flood Lights"),      		devices.ELECTRIC, device_commands.Button_12, nil, 1, {0,1},   TOGGLECLICK)
-- elements["GAUGE_PNT"] 					= default_2_position_tumb(_("Gauge Lights"),     		devices.ELECTRIC, device_commands.Button_13, 42, 1, {0,1},   TOGGLECLICK)
-- elements["WALL_PNT"] 					= default_2_position_tumb(_("Wallpaper"),   		    devices.CUSTOM, device_commands.Button_19, nil, 1, {0,1},   TOGGLECLICK)

-- --MP3 Player
-- elements["MP3_PLAY_PNT"] 				= default_2_position_tumb(_("Mp3 Play"),      						devices.MPT, device_commands.Button_30, nil, 1, {0,1},   TOGGLECLICK)
-- elements["MP3_NEXT_PNT"] 				= default_2_position_tumb(_("Mp3 Next Track"),      				devices.MPT, device_commands.Button_31, nil, 1, {0,1},   TOGGLECLICK)
-- elements["MP3_PREV_PNT"] 				= default_2_position_tumb(_("Mp3 Previous Track"),      			devices.MPT, device_commands.Button_32, nil, 1, {0,1},   TOGGLECLICK)

--I think this was useless
--elements["SMK_ARM_PNT"] 				= default_2_position_tumb(_("Smoke Arm"), 				devices.SMOKE_SYSTEM, device_commands.Button_25, 27, {0,1}, TOGGLECLICK)

			
for i,o in pairs(elements) do
	if  o.class[1] == class_type.TUMB or 
	   (o.class[2]  and o.class[2] == class_type.TUMB) or
	   (o.class[3]  and o.class[3] == class_type.TUMB)  then
	   o.updatable = true
	   o.use_OBB   = true
	end
end